/*                                                Pieter Suurmond, march 1, 2011

  Example using my 'POLYNOM library' to solve a simple quadratic equation:
         2
        x - 0.9 x + 0.81 = 0
                                     jpi/3            -jpi/3
                         = (x - 0.9 e     ) (x - 0.9 e      )

  First download files polynom.hpp and polynom.cpp from 
  http://kmt.hku.nl/~pieter/SOFT/polynom/, for example on the commandline with:

        wget http://kmt.hku.nl/~pieter/SOFT/polynom/polynom.hpp
        wget http://kmt.hku.nl/~pieter/SOFT/polynom/polynom.cpp

  Then compile, for example on the commandline with:

        g++ -O2 -Wall polynom.cpp factor-example.cpp -o factor-example -lm
    
  (Older C++ compilers may require an additional '-lcomplex' before '-lm'.)
  Finally run the program with:
                                ./factor-example

  Which is expected to output:  Finding 2 roots...
                                r0 = (0.45,-0.779423).
                                r1 = (0.45,0.779423).

  Function factor() expects input (a0, a1, etc) in ascending order of degree,
  like this:
                        2       3
        a0 + a1 x + a2 x  + a3 x  + ...  =  (x-r0) (x-r1) (x-r2) (...

  But we use function factor_d() for descending order of degree here!
*/

#include <iostream>
#include <complex>
#include <vector>
using namespace std;
#include "polynom.hpp"      // Needs namespace std, <complex> and <vector>.

int main()
{
    vector<complex<double> >  coeffs(3);  // Input        real,  imag.
                              coeffs[0] = complex<double>( 1.0,  0.0); // x^2
                              coeffs[1] = complex<double>(-0.9,  0.0); // x^1
                              coeffs[2] = complex<double>( 0.81, 0.0); // x^0
    vector<complex<double> >  roots;

    cout << "Finding 2 roots...\n";
    factor_d(coeffs,                    // Input in descending order of degree.
             roots);                    // Output.
    for (unsigned int n = 0; n < roots.size(); n++)           // Print results.
        cout << "r" << n << " = " << roots[n] << ".\n";
    return 0;
}

